/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.entity;

import java.util.ArrayList;
import net.jayjay.dangerzone.entity.EntityBlock;
import net.jayjay.dangerzone.entity.EntityItem;
import net.jayjay.dangerzone.phys.AABB;
import net.jayjay.dangerzone.sound.Sound;
import net.jayjay.dangerzone.world.World;

public class Entity {
    public World world;
    public float xo;
    public float yo;
    public float zo;
    public float x;
    public float y;
    public float z;
    public float xd;
    public float yd;
    public float zd;
    public float yRot;
    public float xRot;
    public AABB bb;
    public boolean onGround = false;
    public boolean removed = false;
    public boolean collidedX = false;
    public boolean collidedY = false;
    public boolean collidedZ = false;
    protected float heightOffset = 0.0f;
    protected float bbWidth = 0.6f;
    protected float bbHeight = 1.6f;
    public String texture;

    public Entity(World world) {
        this.world = world;
        this.resetPos();
    }

    public void resetPos() {
        float shit;
        float x = shit = 1000.0f;
        float y = 128.0f;
        float z = shit;
        this.setPos(x, y, z);
    }

    public void remove() {
        this.removed = true;
        Sound.playDZ2Sound("die");
    }

    protected void setSize(float w, float h2) {
        this.bbWidth = w;
        this.bbHeight = h2;
        this.setEntityBB(w, h2);
    }

    protected void setPos(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        float w = this.bbWidth / 2.0f;
        float h2 = this.bbHeight / 2.0f;
        this.bb = new AABB(x - w, y - h2, z - w, x + w, y + h2, z + w);
    }

    protected void setEntityBB(float width, float height) {
        this.bbWidth = width;
        this.bbHeight = height;
        float w = width / 2.0f;
        float h2 = height / 2.0f;
        this.bb = new AABB(this.x - w, this.y - h2, this.z - w, this.x + w, this.y + h2, this.z + w);
    }

    public void turn(float xo, float yo) {
        this.yRot = (float)((double)this.yRot + (double)xo * 0.15);
        this.xRot = (float)((double)this.xRot - (double)yo * 0.15);
        if (this.xRot < -90.0f) {
            this.xRot = -90.0f;
        }
        if (this.xRot > 90.0f) {
            this.xRot = 90.0f;
        }
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
    }

    public void move(float xa, float ya, float za) {
        if (this.bb == null) {
            this.x += xa;
            this.y += ya;
            this.z += za;
            this.onGround = false;
            this.collidedX = false;
            this.collidedY = false;
            this.collidedZ = false;
            return;
        }
        float xaOrg = xa;
        float yaOrg = ya;
        float zaOrg = za;
        ArrayList<AABB> blockAABBs = this.world.getCubes(this.bb.expand(xa, ya, za));
        ArrayList<Entity> otherEntities = new ArrayList<Entity>();
        ArrayList<AABB> entityAABBs = new ArrayList<AABB>();
        for (Entity entity : this.world.entities) {
            if (entity == this || entity.removed || entity.bb == null || entity instanceof EntityBlock || entity instanceof EntityItem) continue;
            entityAABBs.add(entity.bb);
            otherEntities.add(entity);
        }
        ArrayList<AABB> allAABBs = new ArrayList<AABB>();
        allAABBs.addAll(blockAABBs);
        allAABBs.addAll(entityAABBs);
        for (AABB aabb : allAABBs) {
            ya = aabb.clipYCollide(this.bb, ya);
        }
        this.bb.move(0.0f, ya, 0.0f);
        for (AABB aabb : allAABBs) {
            xa = aabb.clipXCollide(this.bb, xa);
        }
        this.bb.move(xa, 0.0f, 0.0f);
        for (AABB aabb : allAABBs) {
            za = aabb.clipZCollide(this.bb, za);
        }
        this.bb.move(0.0f, 0.0f, za);
        float pushStrength = 0.05f;
        int i2 = 0;
        while (i2 < entityAABBs.size()) {
            AABB otherBB = (AABB)entityAABBs.get(i2);
            Entity otherEntity = (Entity)otherEntities.get(i2);
            if (this.bb.intersects(otherBB)) {
                float centerZ;
                float thisCenterZ;
                float dirZ;
                float centerX;
                float thisCenterX;
                float dirX;
                float dist;
                float dx = Math.min(this.bb.x1, otherBB.x1) - Math.max(this.bb.x0, otherBB.x0);
                float dz = Math.min(this.bb.z1, otherBB.z1) - Math.max(this.bb.z0, otherBB.z0);
                float pushX = 0.0f;
                float pushZ = 0.0f;
                if (dx > 0.0f && dz > 0.0f && (dist = (float)Math.sqrt((dirX = (thisCenterX = (this.bb.x0 + this.bb.x1) / 2.0f) - (centerX = (otherBB.x0 + otherBB.x1) / 2.0f)) * dirX + (dirZ = (thisCenterZ = (this.bb.z0 + this.bb.z1) / 2.0f) - (centerZ = (otherBB.z0 + otherBB.z1) / 2.0f)) * dirZ)) > 0.0f) {
                    pushX = dirX / dist * pushStrength;
                    pushZ = dirZ / dist * pushStrength;
                }
                this.xd += pushX;
                this.zd += pushZ;
                otherEntity.xd -= pushX;
                otherEntity.zd -= pushZ;
            }
            ++i2;
        }
        this.collidedX = false;
        this.collidedY = false;
        this.collidedZ = false;
        boolean bl = this.onGround = yaOrg != ya && yaOrg < 0.0f;
        if (xaOrg != xa) {
            this.xd = 0.0f;
            this.collidedX = true;
        }
        if (yaOrg != ya) {
            this.yd = 0.0f;
            this.collidedY = true;
        }
        if (zaOrg != za) {
            this.zd = 0.0f;
            this.collidedZ = true;
        }
        this.x = (this.bb.x0 + this.bb.x1) / 2.0f;
        this.y = this.bb.y0 + this.heightOffset;
        this.z = (this.bb.z0 + this.bb.z1) / 2.0f;
    }

    public void moveRelative(float xa, float za, float speed) {
        float dist = xa * xa + za * za;
        if (dist >= 0.01f) {
            dist = speed / (float)Math.sqrt(dist);
            float sin = (float)Math.sin((double)this.yRot * Math.PI / 180.0);
            float cos = (float)Math.cos((double)this.yRot * Math.PI / 180.0);
            this.xd += (xa *= dist) * cos - (za *= dist) * sin;
            this.zd += za * cos + xa * sin;
        }
    }

    public boolean isLit() {
        int xTile = (int)this.x;
        int yTile = (int)this.y;
        int zTile = (int)this.z;
        return this.world.isLit(xTile, yTile, zTile);
    }

    public AABB getBoundingBox() {
        return this.bb;
    }

    public void render(float a2) {
    }
}

